/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui.storage;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementEnergyStorage;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.inventory.container.storage.EnergyCellContainer;
import cofh.thermal.lib.client.gui.StorageCellScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class EnergyCellScreen
extends StorageCellScreen<EnergyCellContainer> {
    public static final String TEX_PATH = "thermal:textures/gui/container/energy_cell.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermal:textures/gui/container/energy_cell.png");
    public static final String TEX_INCREMENT = "cofh_core:textures/gui/elements/button_increment.png";
    public static final String TEX_DECREMENT = "cofh_core:textures/gui/elements/button_decrement.png";

    public EnergyCellScreen(EnergyCellContainer container, Inventory inv, Component titleIn) {
        super(container, inv, container.tile, titleIn);
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo((String)"info.thermal.energy_cell");
        this.name = "energy_cell";
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.addElement(new ElementTexture((IGuiAccess)this, 24, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_input.png", 20, 20));
        this.addElement(new ElementTexture((IGuiAccess)this, 132, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_output.png", 20, 20));
        this.addElement((ElementBase)GuiHelper.setClearable((ElementEnergyStorage)GuiHelper.createDefaultEnergyStorage((IGuiAccess)this, (int)80, (int)22, (EnergyStorageCoFH)this.tile.getEnergyStorage()), (ITileCallback)this.tile, (int)0));
        this.addButtons();
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        String input = StringHelper.format((long)this.tile.amountInput);
        String output = StringHelper.format((long)this.tile.amountOutput);
        this.getFontRenderer().m_92883_(matrixStack, input, (float)this.getCenteredOffset(input, 34), 42.0f, 0x404040);
        this.getFontRenderer().m_92883_(matrixStack, output, (float)this.getCenteredOffset(output, 142), 42.0f, 0x404040);
        super.m_7027_(matrixStack, mouseX, mouseY);
    }

    protected void addButtons() {
        ElementBase decInput = new ElementButton((IGuiAccess)this, 19, 56){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                int change = GuiHelper.getChangeAmount((int)mouseButton);
                float pitch = GuiHelper.getPitch((int)mouseButton);
                SoundHelper.playClickSound((float)(pitch -= 0.1f));
                int curInput = ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput;
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput -= change;
                TileConfigPacket.sendToServer((IPacketHandlerTile)EnergyCellScreen.this.tile);
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput = curInput;
                return true;
            }
        }.setTooltipFactory(GuiHelper::createDecControlTooltip).setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountInput > 0);
        ElementBase incInput = new ElementButton((IGuiAccess)this, 35, 56){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                int change = GuiHelper.getChangeAmount((int)mouseButton);
                float pitch = GuiHelper.getPitch((int)mouseButton);
                SoundHelper.playClickSound((float)(pitch += 0.1f));
                int curInput = ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput;
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput += change;
                TileConfigPacket.sendToServer((IPacketHandlerTile)EnergyCellScreen.this.tile);
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountInput = curInput;
                return true;
            }
        }.setTooltipFactory(GuiHelper::createIncControlTooltip).setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountInput < this.tile.getMaxInput());
        ElementBase decOutput = new ElementButton((IGuiAccess)this, 127, 56){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                int change = GuiHelper.getChangeAmount((int)mouseButton);
                float pitch = GuiHelper.getPitch((int)mouseButton);
                SoundHelper.playClickSound((float)(pitch -= 0.1f));
                int curInput = ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput;
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput -= change;
                TileConfigPacket.sendToServer((IPacketHandlerTile)EnergyCellScreen.this.tile);
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput = curInput;
                return true;
            }
        }.setTooltipFactory(GuiHelper::createDecControlTooltip).setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput > 0);
        ElementBase incOutput = new ElementButton((IGuiAccess)this, 143, 56){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                int change = GuiHelper.getChangeAmount((int)mouseButton);
                float pitch = GuiHelper.getPitch((int)mouseButton);
                SoundHelper.playClickSound((float)(pitch += 0.1f));
                int curInput = ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput;
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput += change;
                TileConfigPacket.sendToServer((IPacketHandlerTile)EnergyCellScreen.this.tile);
                ((EnergyCellScreen)EnergyCellScreen.this).tile.amountOutput = curInput;
                return true;
            }
        }.setTooltipFactory(GuiHelper::createIncControlTooltip).setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput < this.tile.getMaxOutput());
        this.addElement(decInput);
        this.addElement(incInput);
        this.addElement(decOutput);
        this.addElement(incOutput);
    }
}

